export interface UserInfo {
  memberId: number | null
  mobilePhone: string
  nickName: string
  avatarUrl: string
  remark: string
  email: string
}

export interface EquityInfo {
  usedAgentCount: number
  maxAgentCount: number
  usedKnowledgeCount: number
  maxKnowledgeCount: number
  points: number
  equityLevel: 'normal' | 'professional' | 'ultimate'
  expireTime: string
}

export interface UserState {
  isLogin: boolean
  token: string
  userInfo: UserInfo
  equityInfo: EquityInfo
}

export enum UserStoreStorageKeyEnum {
  userInfo = 'USER_INFO',
  token = 'TOKEN',
  isLogin = 'IS_LOGIN',
}
