/** 处理环境变量 */
export const wrapperEnv = (envConf: Recordable): ViteEnv => {
  const ret: ViteEnv = {
    VITE_APP_ENV: 'DEV',
    VITE_APP_NAME: 'POC',
    VITE_PORT: 8848,
    VITE_PUBLIC_PATH: '/',
    VITE_ROUTER_MODE: 'hash',
    VITE_VITEST: true,
    VITE_HIDE_HOME: false,
  }

  for (const envName of Object.keys(envConf)) {
    let realName = envConf[envName].replace(/\\n/g, '\n')

    realName = realName === 'true' ? true : realName === 'false' ? false : realName

    if (envName === 'VITE_PORT') {
      realName = Number(realName)
    }

    ;(ret as any)[envName] = realName

    if (typeof realName === 'string') {
      process.env[envName] = realName
    } else if (typeof realName === 'object') {
      process.env[envName] = JSON.stringify(realName)
    }
  }

  return ret
}
