import { type PluginOption } from 'vite'
import vue from '@vitejs/plugin-vue'
import checker from 'vite-plugin-checker'
import { visualizer } from 'rollup-plugin-visualizer'
import AutoImport from 'unplugin-auto-import/vite'
import Components from 'unplugin-vue-components/vite'
import { NaiveUiResolver, VantResolver } from 'unplugin-vue-components/resolvers'
import VueI18nPlugin from '@intlify/unplugin-vue-i18n/vite'
import UnoCSS from 'unocss/vite'
import VueJsx from '@vitejs/plugin-vue-jsx'

export function setupPlugins(isBuild: boolean, envConf: ViteEnv, pathResolve: (dir: string) => string): PluginOption[] {
  const plugins: PluginOption = [
    vue(),
    AutoImport({
      imports: [
        {
          'naive-ui': ['useDialog', 'useMessage', 'useNotification', 'useLoadingBar'],
        },
      ],
    }),
    Components({
      resolvers: [NaiveUiResolver(), VantResolver()],
    }),
    VueI18nPlugin({
      include: [pathResolve('./src/locales/langs/**')],
    }),
    UnoCSS(),
    VueJsx(),
  ]

  if (envConf.VITE_VITEST && !isBuild) {
    plugins.push(checker({ vueTsc: true }))
  }

  if (envConf.VITE_VITEST) {
    plugins.push(
      visualizer({
        filename: 'chunk-stats.html',
      }),
    )
  }

  return plugins
}
