import { request } from '@/utils/request'
import { DefaultPaginationData } from '@/composables/usePagination'

/**
 * @param payload 数据库参数
 * @returns 新建知识库
 */
export function fetchCreateDataBase<T>(payload: object) {
  return request.post<T>('/databaseRest/create.json', payload)
}

/**
 * @param payload 连接数据库参数
 * @returns 连接数据库
 */
export function fetchTestConnectionDataBase<T>(payload: object) {
  return request.post<T>('/databaseRest/testConnection.json', payload)
}

/**
 * @params search 搜索值
 * @returns 获取数据库列表
 */
export function fetchGetDataBaseList<T>(payload: { search: string; pagingInfo: DefaultPaginationData }) {
  return request.post<T>('/databaseRest/getList.json', payload)
}

/**
 * @query id 数据库Id
 * @returns 删除数据库
 */
export function fetchDeleteDataBaseById<T>(id: number) {
  return request.post<T>(`/databaseRest/delete.json?id=${id}`)
}

/**
 * @param payload 数据库参数
 * @returns 更新数据库信息
 */
export function handleUpdateDataBase<T>(payload: object) {
  return request.post<T>('/databaseRest/update.json', payload)
}

/**
 *
 * @param id 数据库Id
 * @returns 获取数据库详情
 */
export function fetchGetDataBaseDetail<T>(id: string) {
  return request.post<T>(`/databaseRest/get.json?id=${id}`)
}

/**
 *
 * @param id 数据库Id
 * @returns 获取数据库表列表
 */
export function fetchGetDBTableList<T>(id: string) {
  return request.post<T>(`/databaseRest/getTableInfo.json?id=${id}`)
}

/**
 * @query ids 数据库Id列表
 * @returns 通过Id列表获取数据库详情
 */
export function fetchGetDataListByIds<T>(ids: number[]) {
  return request.post<T>(`/databaseRest/getByIds.json?ids=${ids}`)
}

/**
 * @params id 数据库Id table 数据表名称
 * @returns 查询数据库表数据
 */
export function fetchGetDBTableDataList<T>(payload: object) {
  return request.post<T>('/databaseRest/getTableData.json', payload)
}
