import { request } from '@/utils/request'

export function fetchUserEquityInfo<T>() {
  return request.post<T>('/equityRest/getCurrentEquity.json')
}

export function fetchCreateEquityOrder<T>(payload: object, controller: AbortController) {
  return request.post<T>('/equityOrderRest/createOrder.json', payload, { signal: controller.signal })
}

export function fetchGetEquityPayQrCode<T>(payload: object, controller: AbortController) {
  return request.post<T>('/payRest/pay.json', null, { params: payload, signal: controller.signal })
}

export function fetchGetPayStatus<T>(payOrderSn: string) {
  return request.post<T>(`/payRest/orderStatus.json?payOrderSn=${payOrderSn}`)
}

export function fetchGetPointsGiftPackageList<T>() {
  return request.post<T>('/equityRest/getPointPackageList.json')
}
