import { request } from '@/utils/request'

/**
 * @returns 获取音色列表
 */
export function fetchGetTimbreList<T>() {
  return request.post<T>('/bizVoiceTimbreRest/getTimbreList.json')
}

/**
 * @query timbreId 音色Id
 * @returns 获取音色详情
 */
export function fetchGetTimbreInfoDetail<T>(timbreId: string) {
  return request.post<T>(`/bizVoiceTimbreRest/getTimbreInfo.json?timbreId=${timbreId}`)
}
