import type { RawEditorOptions } from 'tinymce'

export function createEditorConfig(): RawEditorOptions {
  return {
    selector: '#tinymce-app .tinymce-body',
    license_key: 'gpl',
    language: 'zh_CN',

    toolbar: false,
    placeholder: '请输入你的内容...',

    plugins: ['mfConfirmationBox', 'mfThemeWritingApply', 'wordcount', 'table'],

    highlight_on_focus: false,
    height: '100%',
    statusbar: false,
    promotion: false,
    menubar: false,
    browser_spellcheck: true,

    noneditable_class: 'mce-non-editable',
    content_style: '.mce-content-body::before { color: #c2c2c2 !important; }',
    custom_elements: 'mf-confirmation-box,mf-theme-writing-apply',

    draggable_modal: false,
    paste_data_images: false,
    automatic_uploads: false,
    file_picker_types: 'image',

    extended_valid_elements: 'div[slot|contenteditable|class]',
    external_plugins: {
      mfConfirmationBox: '/tiny-plugins/mf-confirmation-box.js',
      mfThemeWritingApply: '/tiny-plugins/mf-theme-writing-apply.js',
    },
  }
}
