export function checkPlayUnMute() {
  return new Promise<boolean>((resolve) => {
    const audioElem = document.createElement('audio')

    audioElem.src =
      'data:audio/wav;base64,UklGRp4AAABXQVZFZm10IBAAAAABAAEARKwAAIhYAQACABAATElTVBoAAABJTkZPSVNGVA0AAABMYXZmNjEuNy4xMDAAAGRhdGFYAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA=='
    audioElem.muted = false

    const playPromise = audioElem.play()

    if (playPromise !== undefined) {
      playPromise
        .then(() => {
          // 自动播放成功
          resolve(true)
        })
        .catch((error) => {
          if (error.name === 'NotAllowedError' || error.name === 'AbortError') {
            // 自动播放被禁止或中止
            resolve(false)
          } else {
            // 其他错误
            resolve(false)
          }
        })
      // 防止playPromise为空对象，没有finially的情况
      setTimeout(() => {
        audioElem.remove()
        resolve(true)
      }, 300)
    } else {
      // 如果 play() 返回 undefined，可能是浏览器不支持 Promise 风格的 play()
      audioElem.remove()
      resolve(false)
    }
  })
}
