import { useI18n } from 'vue-i18n'

export interface TemplateMenuConfig {
  category: string
  title: string
  templateList: {
    title: string
    icon: string
    doc: string
    template: string
  }[]
}

export function templateMenuConfigFactory(): TemplateMenuConfig[] {
  const { t } = useI18n()

  return [
    {
      category: 'Work',
      title: t('home_module.rich_text_module.template_list.work'),
      templateList: [
        {
          title: t('home_module.rich_text_module.template_list.work_list.t_title_1'),
          icon: 'icon-yingpingmoban',
          doc: t('home_module.rich_text_module.template_list.work_list.t_doc_1'),
          template: t('home_module.rich_text_module.template_list.work_list.t_template_1'),
        },
        {
          title: t('home_module.rich_text_module.template_list.work_list.t_title_2'),
          icon: 'icon-yingpingmoban',
          doc: t('home_module.rich_text_module.template_list.work_list.t_doc_2'),
          template: t('home_module.rich_text_module.template_list.work_list.t_template_2'),
        },
        {
          title: t('home_module.rich_text_module.template_list.work_list.t_title_3'),
          icon: 'icon-yingpingmoban',
          doc: t('home_module.rich_text_module.template_list.work_list.t_doc_3'),
          template: t('home_module.rich_text_module.template_list.work_list.t_template_3'),
        },
        {
          title: t('home_module.rich_text_module.template_list.work_list.t_title_4'),
          icon: 'icon-yingpingmoban',
          doc: t('home_module.rich_text_module.template_list.work_list.t_doc_4'),
          template: t('home_module.rich_text_module.template_list.work_list.t_template_4'),
        },
        {
          title: t('home_module.rich_text_module.template_list.work_list.t_title_5'),
          icon: 'icon-yingpingmoban',
          doc: t('home_module.rich_text_module.template_list.work_list.t_doc_5'),
          template: t('home_module.rich_text_module.template_list.work_list.t_template_5'),
        },
      ],
    },

    {
      category: 'BusinessMarketing',
      title: t('home_module.rich_text_module.template_list.business_marketing'),
      templateList: [
        {
          title: t('home_module.rich_text_module.template_list.business_marketing_list.t_title_1'),
          icon: 'icon-yingpingmoban',
          doc: t('home_module.rich_text_module.template_list.business_marketing_list.t_doc_1'),
          template: t('home_module.rich_text_module.template_list.business_marketing_list.t_template_1'),
        },
        {
          title: t('home_module.rich_text_module.template_list.business_marketing_list.t_title_2'),
          icon: 'icon-yingpingmoban',
          doc: t('home_module.rich_text_module.template_list.business_marketing_list.t_doc_2'),
          template: t('home_module.rich_text_module.template_list.business_marketing_list.t_template_2'),
        },
        {
          title: t('home_module.rich_text_module.template_list.business_marketing_list.t_title_3'),
          icon: 'icon-yingpingmoban',
          doc: t('home_module.rich_text_module.template_list.business_marketing_list.t_doc_3'),
          template: t('home_module.rich_text_module.template_list.business_marketing_list.t_template_3'),
        },
      ],
    },

    {
      category: 'SocialMediaCopywriting',
      title: t('home_module.rich_text_module.template_list.social_media_copywriting'),
      templateList: [
        {
          title: t('home_module.rich_text_module.template_list.social_media_copywriting_list.t_title_1'),
          icon: 'icon-yingpingmoban',
          doc: t('home_module.rich_text_module.template_list.social_media_copywriting_list.t_doc_1'),
          template: t('home_module.rich_text_module.template_list.social_media_copywriting_list.t_template_1'),
        },
        {
          title: t('home_module.rich_text_module.template_list.social_media_copywriting_list.t_title_2'),
          icon: 'icon-yingpingmoban',
          doc: t('home_module.rich_text_module.template_list.social_media_copywriting_list.t_doc_2'),
          template: t('home_module.rich_text_module.template_list.social_media_copywriting_list.t_template_2'),
        },
        {
          title: t('home_module.rich_text_module.template_list.social_media_copywriting_list.t_title_3'),
          icon: 'icon-yingpingmoban',
          doc: t('home_module.rich_text_module.template_list.social_media_copywriting_list.t_doc_3'),
          template: t('home_module.rich_text_module.template_list.social_media_copywriting_list.t_template_3'),
        },
      ],
    },

    {
      category: 'LiteratureAndArt',
      title: t('home_module.rich_text_module.template_list.literature_and_art'),
      templateList: [
        {
          title: t('home_module.rich_text_module.template_list.literature_and_art_list.t_title_1'),
          icon: 'icon-yingpingmoban',
          doc: t('home_module.rich_text_module.template_list.literature_and_art_list.t_doc_1'),
          template: t('home_module.rich_text_module.template_list.literature_and_art_list.t_template_1'),
        },
        {
          title: t('home_module.rich_text_module.template_list.literature_and_art_list.t_title_2'),
          icon: 'icon-yingpingmoban',
          doc: t('home_module.rich_text_module.template_list.literature_and_art_list.t_doc_2'),
          template: t('home_module.rich_text_module.template_list.literature_and_art_list.t_template_2'),
        },
        // {
        //   title: '',
        //   icon: 'icon-yingpingmoban',
        //   doc: '',
        //   template: '',
        // },
      ],
    },
  ]
}
