type SegmentType = 'text' | 'placeholder'

interface Segment {
  type: SegmentType
  content: string
}

export default function textStructureExtractor(str: string): Segment[] {
  const segments = str.split(/\[\[(.*?)\]\]/g)
  const result: Segment[] = []

  segments.forEach((text, index) => {
    if (index % 2 === 0) {
      // 偶数索引：普通文本
      if (text) {
        result.push({ type: 'text', content: text })
      }
    } else {
      // 奇数索引：占位符
      result.push({ type: 'placeholder', content: text })
    }
  })

  return result
}
