export interface QuestionMessageItem {
  role: 'user' | 'assistant'
  content: [
    {
      type: string
      text: string
      image_url: {
        url: string
      }
    },
  ]
}

export interface MultiModelDialogueItem {
  id: string
  icon: string
  modelNickName: string
  topP: number
  temperature: number
  agentSystem: string
  communicationTurn: number
  modelPoints: number
  controller: AbortController | null
  isAnswerResponseWait: boolean
  messageList: Map<string, MessageItemInterface>
}

export type SmartFormTypes = 'BusinessTripForm'

export interface MessageItemInterface {
  role: 'user' | 'assistant'
  avatar: string
  nickName: string
  content: string
  timestamp: number
  isTextContentLoading: boolean
  isAnswerResponseLoading: boolean
  imageUrl?: string
  reasoningContent: string
  knowledgeContentResult: KnowledgeContentResultItem[]
  dbChainSQLContent: string
  pluginResult?: {
    displayFormat: PluginDisplayFormatType
    pluginName: string
    arguments: string
    pluginContent: string
  }
  smartFormInfo?: {
    type: SmartFormTypes
    isDisabled: boolean
    params: string
  }
}

export interface LargeModelItem {
  owner: string
  models: { modelNickName: string; points: number }[]
  icon: string
}
