import { ChannelType } from '@/enums/channel'

export interface IPlatformPointUsage {
  today: number
  week: number
  month: number
  year: number
}

export interface IPlatformPointTrendItem {
  channel: ChannelType
  pointUsages: {
    date: string
    count: number
  }[]
}

export interface IPlatformAgentUsage {
  createCount: number
  usageCount: number
  unPublishCount: number
  publishCount: number
}

export interface IPlatformAgentUsageDetailItem {
  agentTitle: string
  owner: string
  publishStatus: 'Y' | 'N'
  totalPoint: number
  usageCount: number
  lastUsageTime: Date
}
