import globals from 'globals'
import pluginJs from '@eslint/js'
import tseslint from 'typescript-eslint'
import pluginVue from 'eslint-plugin-vue'
import eslintPluginPrettierRecommended from 'eslint-plugin-prettier/recommended'
import vueParser from 'vue-eslint-parser'
import tsParser from '@typescript-eslint/parser'
import unocss from '@unocss/eslint-config/flat'

export default [
  unocss,
  pluginJs.configs.recommended,

  ...tseslint.configs.recommended,
  ...pluginVue.configs['flat/recommended'],

  {
    languageOptions: {
      globals: {
        ...globals.browser,
        NodeJS: 'readonly',
        Recordable: 'readonly',
        ViteEnv: 'readonly',
        AnyObject: 'readonly',
        ConversationMessageItem: 'readonly',
        ConversationMessageItemInfo: 'readonly',
        MittEvents: 'readonly',
        I18n: 'readonly',
        google: 'readonly',
      },
      parser: vueParser,
      parserOptions: {
        parser: tsParser,
        sourceType: 'module',
        ecmaVersion: 'latest',
        ecmaFeatures: {
          jsx: true,
        },
      },
    },
    rules: {
      'no-console': 'warn',

      'vue/attribute-hyphenation': 'error',
      'vue/multi-word-component-names': 'off',
      'vue/component-name-in-template-casing': [
        'error',
        'PascalCase',
        {
          registeredComponentsOnly: true,
          ignores: [],
        },
      ],
      'vue/v-on-event-hyphenation': [
        'error',
        'always',
        {
          autofix: true,
          ignore: [],
        },
      ],

      '@typescript-eslint/no-unused-vars': [
        'error',
        {
          argsIgnorePattern: '^_',
          varsIgnorePattern: '^_',
        },
      ],
      '@typescript-eslint/no-explicit-any': 'off',
      '@typescript-eslint/array-type': 'error',

      'unocss/order': 'off',
    },
  },

  eslintPluginPrettierRecommended,

  {
    ignores: ['dist/', 'public/'],
  },
]
