import { type App } from 'vue'
import { createI18n } from 'vue-i18n'
import messages from './messages'
import { ss } from '@/utils/storage'

export const defaultLocale = 'zh-HK'

const i18n = createI18n<[I18n.Schema], I18n.LangType>({
  legacy: false,
  locale: ss.get('i18nextLng') || defaultLocale,
  fallbackLocale: 'zh-CN',
  messages,
})

export function setupI18n(app: App) {
  app.use(i18n)
}

export default i18n
