import { type RouteRecordRaw } from 'vue-router'

export default [
  {
    path: '/login',
    name: 'Login',
    meta: {
      rank: 1001,
      title: 'router_title_module.login',
    },
    component: () => import('@/views/login/login.vue'),
  },
  // {
  //   path: '/404',
  //   name: 'NotFound',
  //   meta: {
  //     title: '未找到该页面',
  //   },
  //   component: () => import('@/views/exception/404.vue'),
  // },
  {
    path: '/500',
    name: 'ServerError',
    meta: {
      rank: 1001,
      title: 'router_title_module.server_error',
    },
    component: () => import('@/views/exception/500.vue'),
  },
  {
    path: '/:pathMatch(.*)*',
    name: 'Universal',
    meta: {
      rank: 1001,
      title: 'router_title_module.universal',
    },
    component: () => import('@/views/exception/404.vue'),
  },
] as RouteRecordRaw[]
