tinymce.PluginManager.add('mfConfirmationBox', (editor) => {
  editor.on('init', () => {
    const win = editor.getWin()

    class MfConfirmationBox extends win.HTMLElement {
      static observedAttributes = ['data-init-text', 'data-is-response-end', 'data-document-title']

      constructor() {
        super()

        this.initConnect = false

        const shadowRoot = this.attachShadow({ mode: 'open' })

        const tpEl = document.createElement('template')

        tpEl.insertAdjacentHTML('beforeend', `
          <div contenteditable="false" class="confirmation-box">
            <div class="header">
              <span>生成内容预览</span>
            </div>
            <h3 class="document-title">标题：</h3>
            <div id="content">
              <slot></slot>
            </div>
            <div class="footer">
              <div class="left">内容由AI生成，请注意甄别真实性</div>
              <div class="right btn-wrapper">
                <button name="btn" class="cancel-btn">取消</button>
                <button class="confirm-btn">应用</button>
              </div>
            </div>
          </div>
        `)

        const btnWrapEl = tpEl.children[0].lastElementChild.lastElementChild

        /* 取消 按钮 */
        btnWrapEl.children[0].onclick = () => {
          editor.execCommand('onBtnClick', 'cancel')

          editor.dom.remove(this, false)
        }

        /* 应用 按钮 */
        btnWrapEl.children[1].onclick = () => {
          editor.execCommand('onBtnClick', 'apply')

          const divEl = document.createElement('div')
          const contentEl = shadowRoot.getElementById('content')
          divEl.append(...contentEl.childNodes)

          editor.dom.replace(divEl, this, false)
        }

        const styleEl = document.createElement('style')
        styleEl.textContent = `
          .confirmation-box {
            border-radius: 10px;
            box-shadow: 0 5px 10px 0 rgba(184, 184, 184, 0.50);
            padding: 12px;
            box-sizing: border-box;
            width: 100%;
            user-select: none;
          }
      
          .confirmation-box .header {
            color: #999;
            font-size: 12px;
            margin-bottom: 14px;
          }
      
          .confirmation-box .footer {
            margin-top: 10px;
            padding-top: 18px;
            display: flex;
            justify-content: space-between;
            border-top: solid 1px #EEE;
          }

          .confirmation-box .footer .btn-wrapper {
            display: none;
          }
      
          .confirmation-box .footer .left {
            color: #999;
            font-size: 12px;
            display: flex;
            align-items: center;
          }
      
          .confirmation-box .footer .right .cancel-btn,
          .confirmation-box .footer .right .confirm-btn {
            border-radius: 30px;
            padding: 6px 20px;
            border: 1px solid transparent;
            font-size: 12px;
            cursor: pointer;
          }
      
          .confirmation-box .footer .right .cancel-btn {
            background-color: #eff7ff;
            color: #0085ff;
            border-color: #0085ff;
          }
      
          .confirmation-box .footer .right .confirm-btn {
            background-color: #0085ff;
            color: #fff;
          }
        `
        tpEl.insertAdjacentElement('afterbegin', styleEl)

        shadowRoot.append(...tpEl.children)
      }
  
      connectedCallback() {
        if (!this.initConnect) {
          const contentEl = this.shadowRoot.getElementById('content')
          const contentString = editor.dom.getAttrib(this, 'data-init-text') || ''
          contentEl.innerHTML = decodeURIComponent(contentString)
          editor.dom.setAttrib(this, 'data-init-text', '')

          this.initConnect = true
        }
      }

      attributeChangedCallback(name, oldValue, newValue) {
        // console.log(`====( 属性 ${name}：${oldValue} --》 ${newValue} )====`)

        // if (name === 'data-text' && this.initConnect) {
        //   const contentEl = this.shadowRoot.getElementById('content')
        //   const contentString = editor.dom.getAttrib(this, 'data-text') || ''
        //   contentEl.innerHTML = decodeURIComponent(contentString)
        // }

        if (name === 'data-is-response-end') {
          const btnWrapperEl = this.shadowRoot.querySelector('.confirmation-box .btn-wrapper')

          if (newValue === 'true') {
            btnWrapperEl && (btnWrapperEl.style.display = 'block')
          } else {
            if (btnWrapperEl && btnWrapperEl.style.display !== 'none') {
              btnWrapperEl.style.display = 'none'
            }
          }
        }

        if (name === 'data-document-title' && newValue) {
          const titleEl = this.shadowRoot.querySelector('.confirmation-box .document-title')

          titleEl.innerHTML = `标题：${newValue}`
        }
      }
    }
    
    win.customElements.define('mf-confirmation-box', MfConfirmationBox)
  
    // editor.on('keydown', (e) => {
    //   if (e.code === 'PageDown') {
    //     editor.insertContent(`<mf-confirmation-box id="fXDZDqAKHA" data-is-response-end="true" data-init-text="${encodeURIComponent('<div>这是应用内容</div>')}"></mf-confirmation-box><br />`)
    //     // editor.execCommand('mceSetContent', false, '<mf-confirmation-box size="100">你好</mf-confirmation-box>')
    //   } 
      
    //   if (e.code === 'PageUp') {
    //     const el = editor.dom.get('fXDZDqAKHA')
    //     console.log(el.shadowRoot)
    //     // editor.dom.setAttrib(el, 'data-text', `${decodeURIComponent(editor.dom.getAttrib(el, 'data-text') || '')}${Date.now()}`)
    //   }
    // })
  })

  return {
    getMetadata: () => ({
      name: 'content confirmation box',
      url: 'https://marketingai-sit.gsstcloud.com',
    }),
  }
})
