import type { QuillOptions } from 'quill'
import type Quill from 'quill'

interface ConfigInterface {
  placeholder: string
  keyboardCallback: {
    enter?: (quillInst?: Quill, range?: any, context?: any) => void
    at?: (quillInst?: Quill, range?: any, context?: any) => void
  }
}

export function getQuillOptions(config: ConfigInterface): QuillOptions {
  return {
    placeholder: config.placeholder,
    modules: {
      keyboard: {
        bindings: {
          enter: {
            key: 'Enter',
            handler: function (range: any, context: any) {
              if (config.keyboardCallback.enter) {
                config.keyboardCallback.enter((this as any).quill as Quill, range, context)
              }
            },
          },
          // '@': {
          //   key: '@',
          //   shiftKey: true,
          //   handler: function (range: any, context: any) {
          //     if (config.keyboardCallback.at) {
          //       config.keyboardCallback.at((this as any).quill as Quill, range, context)
          //     }
          //   },
          // },
          // tab: {
          //   key: 'Tab',
          //   handler: function () {
          //   },
          // },
        },
      },
    },
  }
}
