import i18n from '@/locales'
import { ApiCallDetailItem } from './type'

const t = i18n.global.t

export function createApiCallDetailColumns() {
  return [
    {
      title: () => (
        <span>
          {t('personal_space_module.agent_module.agent_setting_module.agent_publish_module.api_call_datetime')}
        </span>
      ),
      key: 'dateTime',
      align: 'center',
      ellipsis: {
        tooltip: true,
      },
      render(row: ApiCallDetailItem) {
        return row.dateTime || '--'
      },
    },
    {
      title: () => <span>{t('analysis_module.consume_points')}</span>,
      key: 'count',
      align: 'center',
      ellipsis: {
        tooltip: true,
      },
      render(row: ApiCallDetailItem) {
        return row.count.toFixed(2) || '--'
      },
    },
  ]
}
