import { NEllipsis, NPopover, NSwitch } from 'naive-ui'
import i18n from '@/locales'
import { QAKnowledgeChunkContentItem, QAKnowledgeChunkKeyItem } from '../types'

const t = i18n.global.t

export function createQAKnowledgeChunkColumn(
  chunkColumnKey: QAKnowledgeChunkKeyItem[],
  handleKnowledgeChunkTableAction: (
    actionType: string,
    chunkRelationId: string,
    KnowledgeItem?: QAKnowledgeChunkContentItem,
  ) => void,
) {
  return [
    {
      type: 'selection',
      fixed: 'left',
      className: 'qa-knowledge-chunk-selection',
    },
    {
      title: () => <span class='font-family-medium'>{t('personal_space_module.knowledge_module.no')}</span>,
      key: 'key',
      minWidth: 92,
      className: 'qa-knowledge-chunk-index',
      render: (_: any, index: number) => {
        return `${index + 1}`
      },
    },
    ...chunkColumnKey.map((item) => {
      return {
        title: () => {
          return (
            <div class='flex items-center gap-[10px]'>
              <NEllipsis class='font-family-medium max-w-full' tooltip={{ width: 200 }}>
                {item.structName || '--'}
              </NEllipsis>
              {item.isIndex === 'Y' && (
                <span class='border-theme-color text-theme-color rounded-theme flex-shrink-0 border px-[11px] py-[2px] text-xs'>
                  {t('personal_space_module.knowledge_module.index')}
                </span>
              )}
            </div>
          )
        },
        key: item.structId,
        align: 'left',
        width: 246,
        className: 'qa-knowledge-chunk-item',
        render(row: QAKnowledgeChunkContentItem & { expanded: boolean }) {
          return (
            <div
              class={[row.expanded ? '' : 'line-clamp-1', 'cursor-pointer']}
              onClick={() => {
                row.expanded = !row.expanded
              }}
            >
              {row.chunkInfo.find((chunkInfo) => chunkInfo.structId === item.structId)?.content || '--'}
            </div>
          )
        },
      }
    }),
    {
      title: () => <span class='font-family-medium pl-1.5'>{t('common_module.function')}</span>,
      key: 'action',
      align: 'left',
      fixed: 'right',
      width: 200,
      render(row: QAKnowledgeChunkContentItem) {
        return (
          <div class='flex-center gap-[10px]'>
            <NPopover
              v-slots={{
                trigger: () => (
                  <i
                    class='iconfont icon-edit-document hover:text-font-color hover:bg-background-color flex h-6 w-6 cursor-pointer items-center justify-center rounded-full text-sm'
                    onClick={() => {
                      handleKnowledgeChunkTableAction('edit', row.chunkRelationId, row)
                    }}
                  />
                ),
              }}
            >
              <span>{t('common_module.data_table_module.edit')}</span>
            </NPopover>

            <NPopover
              v-slots={{
                trigger: () => (
                  <i
                    class='iconfont icon-add-chunk-up hover:text-font-color hover:bg-background-color flex h-6 w-6 cursor-pointer items-center justify-center rounded-full text-sm'
                    onClick={() => {
                      handleKnowledgeChunkTableAction('addUp', row.chunkRelationId, row)
                    }}
                  />
                ),
              }}
            >
              <span>{t('personal_space_module.knowledge_module.add_chunk_up_message')}</span>
            </NPopover>

            <NPopover
              v-slots={{
                trigger: () => (
                  <i
                    class='iconfont icon-add-chunk-down hover:text-font-color hover:bg-background-color flex h-6 w-6 cursor-pointer items-center justify-center rounded-full text-sm'
                    onClick={() => {
                      handleKnowledgeChunkTableAction('addDown', row.chunkRelationId, row)
                    }}
                  />
                ),
              }}
            >
              <span>{t('personal_space_module.knowledge_module.add_chunk_down_message')}</span>
            </NPopover>

            <NPopover
              v-slots={{
                trigger: () => (
                  <i
                    class='iconfont icon-delete hover:text-font-color hover:bg-background-color flex h-6 w-6 cursor-pointer items-center justify-center rounded-full text-sm'
                    onClick={() => {
                      handleKnowledgeChunkTableAction('delete', row.chunkRelationId)
                    }}
                  />
                ),
              }}
            >
              <span>{t('common_module.delete')}</span>
            </NPopover>

            <NSwitch
              value={row.isOpen === 'Y'}
              size='small'
              loading={row.isOpenLoading}
              onUpdateValue={() => handleKnowledgeChunkTableAction('updateOpen', row.chunkRelationId, row)}
            />
          </div>
        )
      },
    },
  ]
}
