export enum TrainStatus {
  UNOPENED = 'Unopened',
  LINE = 'Line',
  TRAINING = 'Training',
  COMPLETE = 'Complete',
  FAIL = 'Fail',
}

export interface KnowledgeItem {
  id: number
  knowledgeName: string
  desc: string
  trainStatus: TrainStatus
  knowledgeType: 'Base' | 'QA'
  isOpen: 'Y' | 'N'
  createdTime: Date
  documentInfos: KnowledgeDocumentItem[]
  memberId: string
}

export interface SegmentationConfigInterface {
  segmentationType: 'DEFAULT' | 'IDENTIFIER' | 'NUMBER_Of_WORDS'
  chunkSize: number
  scrapSize: number
  repetitionRate: number
  relationInfo: string[]
  regex: string
  punctuations: string[]
}

export interface KnowledgeDocumentItem {
  kdId: number
  knowledgeType: string
  documentName: string
  documentUrl: string
  charCount: number
  uploadTime: Date
  isEnable: 'Y' | 'N'
  knowledgeId: string
  trainStatus: TrainStatus
  segmentationConfig: SegmentationConfigInterface
}

export interface KnowledgeChunkItem {
  knowledgeId: string
  chunkContent: string
  chunkRelationId: string
  chunkSort: number
  isOpen: 'Y' | 'N'
  isOpenLoading?: boolean
}

export interface QAKnowledgeChunkKeyItem {
  structId: number
  isIndex: 'Y' | 'N'
  sort: number
  structName: string
}

export interface QAKnowledgeChunkContentItem {
  chunkRelationId: string
  chunkSort: number
  chunkInfo: QAKnowledgeChunkInfoItem[]
  isOpen: 'Y' | 'N'
  isOpenLoading?: boolean
}

export interface QAKnowledgeChunkInfoItem {
  structId: number
  content: string
}
