import { defineConfig, transformerDirectives, presetUno } from 'unocss'

export default defineConfig({
  rules: [
    [
      /^bg-svg-([\w-]+)$/,
      ([, dirFname]) => {
        let url = '@/assets/svgs/'

        const dirFnameArr = dirFname.split('-')

        if (dirFnameArr.length > 1) {
          const [dirStr, fname] = dirFnameArr
          const dirPath = dirStr.split('_').join('/')

          url += `${dirPath}/${fname.replace(/_/g, '-')}.svg`
        } else {
          url += `${dirFname.replace(/_/g, '-')}.svg`
        }

        return { 'background-image': `url(${url})`, 'background-size': 'cover' }
      },
    ],
    [
      /^bg-px-([\w_-]+)-(png|jpg|gif)$/,
      ([, dirFname, suffix]) => {
        let url = '@/assets/images/'

        const dirFnameArr = dirFname.split('-')

        if (dirFnameArr.length > 1) {
          const [dirStr, fname] = dirFnameArr
          const dirPath = dirStr.split('_').join('/')

          url += `${dirPath}/${fname.replace(/_/g, '-')}.${suffix}`
        } else {
          url += `${dirFname.replace(/_/g, '-')}.${suffix}`
        }

        return {
          'background-image': `url(${url})`,
          'background-size': 'cover',
        }
      },
    ],
  ],
  theme: {
    colors: {
      'theme-color': '#000DFF',
      'hover-theme-color': '#575FFF',
      'active-color': '#EFF0FF',
      'font-color': '#333333',
      'gray-font-color': '#999999',
      'error-font-color': '#F25744',
      'inactive-border-color': '#CCCCCC',
      'background-color': '#F3F5F8',
      'hover-background-color': '#E3E8F0',
    },
    height: {
      navbar: '56px',
      content: 'calc(100% - 56px)',
    },
    borderRadius: {
      theme: '5px',
    },
    animation: {
      keyframes: {
        'card-reverse': `{ 0% { transform: rotateY(0deg); } 100% { transform: rotateY(1turn); } }`,
        training: `{ 0% { transform: translateX(-100%) } 100% { transform: translateX(100%); } }`,
      },
      durations: {
        'card-reverse': '1s',
        training: '1.2s',
      },
      timingFns: {
        'card-reverse': 'ease-in-out',
      },
      counts: {
        'card-reverse': '1',
        training: 'infinite',
      },
    },
    fontFamily: {
      'family-medium': 'SourceHanSansCN-Medium',
    },
  },
  shortcuts: {
    'flex-center': 'flex items-center justify-center',
  },
  presets: [presetUno()],
  transformers: [transformerDirectives()],
})
