import { computed } from 'vue'
import { breakpointsTailwind, useBreakpoints } from '@vueuse/core'

export function useLayoutConfig() {
  const breakpoints = useBreakpoints(breakpointsTailwind)
  const isMobileLayout = breakpoints.smaller('sm')

  const isMobile = computed(() => {
    return /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)
  })

  return { isMobileLayout, isMobile }
}
