export interface QuestionMessageItem {
  role: 'user' | 'assistant'
  content: [
    {
      type: string
      text: string
      image_url: {
        url: string
      }
    },
  ]
}

export interface MultiModelDialogueItem {
  id: string
  icon: string
  modelNickName: string
  topP: number
  temperature: number
  agentSystem: string
  communicationTurn: number
  modelPoints: number
  controller: AbortController | null
  isAnswerResponseWait: boolean
  messageList: Map<string, MessageItemInterface>
}

export interface MessageItemInterface {
  role: 'user' | 'assistant'
  avatar: string
  nickName: string
  content: string
  timestamp: number
  isTextContentLoading: boolean
  isAnswerResponseLoading: boolean
  pluginName?: string
  imageUrl?: string
  reasoningContent: string
  knowledgeContentResult: KnowledgeContentResultItem[]
}

export interface LargeModelItem {
  owner: string
  models: { modelNickName: string; points: number }[]
  icon: string
}
