import i18n from '@/locales'
import { IPlatformAgentUsageDetailItem } from '../type'
import { formatDateTime } from '@/utils/date-formatter'

const t = i18n.global.t

export function createPlatformAgentUsageDetail() {
  return [
    {
      title: () => <span>{t('statistic_module.agent_title')}</span>,
      key: 'agentTitle',
      align: 'left',
      width: '369px',
      ellipsis: {
        tooltip: true,
      },
      render(row: IPlatformAgentUsageDetailItem) {
        return row.agentTitle || '--'
      },
    },
    {
      title: () => <span>{t('analysis_module.consume_points')}</span>,
      key: 'totalPoint',
      align: 'left',
      width: '188px',
      ellipsis: {
        tooltip: true,
      },
      render(row: IPlatformAgentUsageDetailItem) {
        return row.totalPoint.toFixed(2) || '--'
      },
    },
    {
      title: () => <span>{t('statistic_module.agent_status')}</span>,
      key: 'publishStatus',
      align: 'left',
      width: '160px',
      ellipsis: {
        tooltip: true,
      },
      render(row: IPlatformAgentUsageDetailItem) {
        return row.publishStatus === 'Y' ? t('common_module.published') : t('common_module.unpublished')
      },
    },
    {
      title: () => <span>{t('statistic_module.owner')}</span>,
      key: 'owner',
      align: 'left',
      width: '236px',
      ellipsis: {
        tooltip: true,
      },
      render(row: IPlatformAgentUsageDetailItem) {
        return row.owner || '--'
      },
    },
    {
      title: () => <span>{t('statistic_module.usage_count')}</span>,
      key: 'usageCount',
      align: 'left',
      width: '200px',
      ellipsis: {
        tooltip: true,
      },
      render(row: IPlatformAgentUsageDetailItem) {
        return row.usageCount || '--'
      },
    },
    {
      title: () => <span>{t('statistic_module.last_usage_time')}</span>,
      key: 'lastUsageTime',
      align: 'left',
      width: '360px',
      ellipsis: {
        tooltip: true,
      },
      render(row: IPlatformAgentUsageDetailItem) {
        return row.lastUsageTime ? formatDateTime(row.lastUsageTime) : '--'
      },
    },
  ]
}
