import { request } from '@/utils/request'

export function fetchLogin<T>(payload: {
  loginChannel: 'MEMBER_PLATFOMR_SMS' | 'MEMBER_PLATFOMR_EMAIL' | 'MEMBER_PLATFOMR_PW' | 'MEMBER_PLATFOMR_GOOGLE'
  account: string
  password?: string
  authCode?: string
}) {
  return request.post<T>('/bizMemberInfoRest/doLogin.json', payload)
}

export function fetchSMSCode<T>(phoneNumber: string) {
  return request.post<T>(`/smsRest/smsDelivered.json?phone=${phoneNumber}`)
}

export function fetchEmailCode<T>(emailAddress: string) {
  return request.post<T>(`/sendEmailRest/sendEmailCode.json?emailAddress=${emailAddress}`)
}

export function fetchUserDetailInfo<T>() {
  return request.post<T>('/bizMemberInfoRest/getCurrentMemberInfo.json')
}

export function fetchGetMemberInfoById<T>(memberId: number) {
  return request.post<T>(`/bizMemberInfoRest/getMemberNickName.json?memberId=${memberId}`)
}

export function fetchUserInfoUpdate<T>(userInfo: object) {
  return request.post<T>('/bizMemberInfoRest/updateMemberInfo.json', userInfo)
}

export function fetchVerifyCode<T>(account: string, code: string) {
  return request.post<T>('/judgeCodeRest/judgeCodeReturnAuthCode.json', null, { params: { account, code } })
}

export function fetchUserPasswordUpdate<T>(authCode: string, password: string) {
  return request.post<T>('/bizMemberInfoRest/changeMemberPassword.json', null, {
    params: { authCode, password },
  })
}

export function fetchGoogleClientId<T>() {
  return request.post<T>('/googleConfigRest/getClientId.json')
}
