import { defineStore } from 'pinia'
import { PersonalAppConfigState } from '../types/personal-app-config'
import i18n from '@/locales'

const { t } = i18n.global

export function defaultPersonalAppConfigState(): PersonalAppConfigState {
  return {
    baseInfo: {
      agentId: '',
      agentTitle: t('personal_space_module.agent_module.agent_setting_module.my_agent'),
      agentAvatar: 'https://gsst-poe-sit.gz.bcebos.com/data/20240911/1726041369632.webp',
      agentDesc: '',
      agentSystem: '',
      agentPublishStatus: 'draft',
      memberId: 0,
      publishTime: '',
    },
    commConfig: {
      preamble: '',
      featuredQuestions: [],
      continuousQuestionStatus: 'default',
      continuousQuestionSystem: '',
      continuousQuestionTurn: 3,
      variableStructure: null,
      isLongMemory: 'N',
    },
    knowledgeConfig: {
      knowledgeIds: [],
      isDocumentParsing: 'N',
      knowledgeResponseType: 'default',
      knowledgeCustomResponse: [],
      knowledgeSearchType: 'MIX',
      knowledgeSimilarity: 0.4,
      knowledgeNResult: 3,
    },
    commModelConfig: {
      largeModel: '文心4.0 （8K）',
      topP: 0.7,
      communicationTurn: 5,
      temperature: 0.5,
    },
    voiceConfig: {
      defaultOpen: 'Y',
      timbreId: '',
    },
    modifiedTime: new Date(),
    createdTime: '',
    isCollect: '',
    isSale: '',
    agentPublishId: 1,
    unitIds: [],
  }
}

export const usePersonalAppConfigStore = defineStore('personal-app-config-store', {
  state: (): PersonalAppConfigState => defaultPersonalAppConfigState(),

  actions: {
    updatePersonalAppConfigState(personalAppConfigState: Partial<PersonalAppConfigState>) {
      this.$state = { ...this.$state, ...personalAppConfigState }
    },

    resetPersonalAppConfigState() {
      this.$state = defaultPersonalAppConfigState()
    },
  },
})
