export interface VariableStructureItem {
  key: string
  variableDefault: string | null
}

export interface PersonalAppConfigState {
  agentType?: string
  baseInfo: {
    agentId: string //应用ID
    agentTitle: string //应用标题
    agentAvatar: string //应用头像
    agentDesc: string //应用描述
    agentSystem: string //角色指令
    agentPublishStatus: 'draft' | 'publish' //发布状态  draft-草稿 publish-发布
    memberId: number
    publishTime: string
  }
  clickNumber?: number
  collectNumber?: number
  commConfig: {
    preamble: string //开场白
    featuredQuestions: string[] //推荐问
    continuousQuestionStatus: 'default' | 'close' //追问状态
    continuousQuestionSystem: string // 追问提示词   customizable时必填
    continuousQuestionTurn: number // 追问轮次 1-5 customizable时必填
    variableStructure: VariableStructureItem[] | null
    isLongMemory: string
  }
  knowledgeConfig: {
    knowledgeIds: number[] //知识库ID
    isDocumentParsing: 'Y' | 'N' //是否开启文档解析 Y-开启 N-关闭
    knowledgeResponseType: 'default' | 'custom' //超纲问题回复 default 默认回复 custom-自定义回复
    knowledgeCustomResponse: string[] //knowledgeCustomResponse
    knowledgeSearchType: 'MIX' | 'KEY_WORD' | 'SEMANTICS' //知识库检索策略
    knowledgeSimilarity: number //最低相似度 0.01-0.99
    knowledgeNResult: number //知识库返回结果数 1-10
  }
  databaseConfig: {
    ids: number[]
  }
  commModelConfig: {
    largeModel: string //大模型
    topP: number //topP 0-1.00
    communicationTurn: number //参考对话轮次 0-100
    temperature: number //多样性 0-1.00
  }
  voiceConfig: {
    defaultOpen: 'Y' | 'N' //是否默认开启 Y-开启 N-关闭
    timbreId: string //音色ID
  }
  popularity?: number
  modifiedTime: Date
  createdTime: string
  id?: number
  isCollect: string
  isSale: string
  isCopy?: string
  agentPublishId: number
  unitIds: string[]
}
