import { request } from '@/utils/request'

export function fetchLogin<T>(payload: {
  loginChannel: 'MEMBER_PLATFOMR_SMS' | 'MEMBER_PLATFOMR_EMAIL' | 'MEMBER_PLATFOMR_PW'
  account: string
  password?: string
  authCode?: string
}) {
  return request.post<T>('/bizMemberInfoRest/doLogin.json', payload)
}

export function fetchSMSCode<T>(phoneNumber: string) {
  return request.post<T>(`/smsRest/smsDelivered.json?phone=${phoneNumber}`)
}

export function fetchEmailCode<T>(emailAddress: string) {
  return request.post<T>(`/sendEmailRest/sendEmailCode.json?emailAddress=${emailAddress}`)
}

export function fetchUserDetailInfo<T>() {
  return request.post<T>('/bizMemberInfoRest/getCurrentMemberInfo.json')
}

export function fetchGetMemberInfoById<T>(memberId: number) {
  return request.post<T>(`/bizMemberInfoRest/getMemberNickName.json?memberId=${memberId}`)
}
