import { createApp } from 'vue'
import { setupStore } from './store/'
import { setupRouter } from './router'
import { setupI18n } from './locales'
import { setupDiscrete } from '@/utils/create-discrete'
import App from './app.vue'
import '@/styles/reset.scss'
import 'virtual:uno.css'
import '@unocss/reset/normalize.css'
import '@unocss/reset/tailwind.css'
import LoadingDirective from './directives/loading'

async function bootstrap() {
  const app = createApp(App)

  setupDiscrete()
  setupStore(app)
  setupI18n(app)
  await setupRouter(app)

  // 添加meta标签，用于处理使用 Naive UI 和 Tailwind CSS 时的样式覆盖问题
  const meta = document.createElement('meta')
  meta.name = 'naive-ui-style'
  document.head.appendChild(meta)

  app.directive('loading', LoadingDirective)

  app.mount('#app')
}

bootstrap()
