import { defineStore } from 'pinia'

export const useDesignSettingStore = defineStore('design-setting-store', {
  state: () => ({
    sidebarDisplayStatus: 'expand', // status: 'expand' | 'collapse' | 'hidden'
    isMobile: /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent),
    isMobileLayout: false,
    showSidebarDrawer: false,
  }),

  actions: {
    toggleSidebarDisplayStatus(status: 'expand' | 'collapse' | 'hidden') {
      this.sidebarDisplayStatus = status
    },
    toggleIsMobileLayout(result: boolean) {
      this.isMobileLayout = result
    },
    changeShowSidebarDrawer(result: boolean) {
      this.showSidebarDrawer = result
    },
  },
})
