import { defineStore } from 'pinia'
import { PersonalAppConfigState } from '../types/personal-app-config'

export function defaultPersonalAppConfigState(): PersonalAppConfigState {
  return {
    baseInfo: {
      agentId: '',
      agentTitle: '我的Agent应用',
      agentAvatar: 'https://gsst-poe-sit.gz.bcebos.com/data/20240911/1726041369632.webp',
      agentDesc: '',
      agentSystem: '',
      agentPublishStatus: 'draft',
      memberId: 0,
      publishTime: '',
    },
    commConfig: {
      preamble: '',
      featuredQuestions: [],
      continuousQuestionStatus: 'default',
      continuousQuestionSystem: '',
      continuousQuestionTurn: 3,
      variableStructure: [],
      isLongMemory: 'N',
    },
    knowledgeConfig: {
      knowledgeIds: [],
    },
    commModelConfig: {
      largeModel: '文心4.0 （8K）',
      topP: 0.7,
      communicationTurn: 3,
      temperature: 0.5,
    },
    modifiedTime: new Date(),
    createdTime: '',
    isCollect: '',
    isSale: '',
    agentPublishId: 1,
  }
}

export const usePersonalAppConfigStore = defineStore('personal-app-config-store', {
  state: (): PersonalAppConfigState => defaultPersonalAppConfigState(),

  actions: {
    updatePersonalAppConfigState(personalAppConfigState: Partial<PersonalAppConfigState>) {
      this.$state = { ...this.$state, ...personalAppConfigState }
    },

    resetPersonalAppConfigState() {
      this.$state = defaultPersonalAppConfigState()
    },
  },
})
