import { type PluginOption } from 'vite'
import vue from '@vitejs/plugin-vue'
import checker from 'vite-plugin-checker'
import { visualizer } from 'rollup-plugin-visualizer'
import AutoImport from 'unplugin-auto-import/vite'
import Components from 'unplugin-vue-components/vite'
import { NaiveUiResolver } from 'unplugin-vue-components/resolvers'
import VueI18nPlugin from '@intlify/unplugin-vue-i18n/vite'
import UnoCSS from 'unocss/vite'

export function setupPlugins(isBuild: boolean, envConf: ViteEnv, pathResolve: (dir: string) => string): PluginOption[] {
  const lifecycle = process.env.npm_lifecycle_event

  const plugins: PluginOption = [
    vue(),
    AutoImport({
      imports: [
        {
          'naive-ui': ['useDialog', 'useMessage', 'useNotification', 'useLoadingBar'],
        },
      ],
    }),
    Components({
      resolvers: [NaiveUiResolver()],
    }),
    VueI18nPlugin({
      include: [pathResolve('./src/locales/langs/**')],
    }),
    UnoCSS(),
  ]

  if (envConf.VITE_VITEST && !isBuild) {
    plugins.push(checker({ vueTsc: true }))
  }

  if (lifecycle === 'report') {
    plugins.push(visualizer())
  }

  return plugins
}
