import { type App } from 'vue'
import { createI18n } from 'vue-i18n'
import messages from './messages'

const i18n = createI18n({
  legacy: false,
  locale: 'zh-HK',
  fallbackLocale: 'zh-CN',
  messages,
})

export function setupI18n(app: App) {
  app.use(i18n)
}

export default i18n
