import { type RouteRecordRaw } from 'vue-router'

export default [
  {
    path: '/personal-space',
    name: 'PersonalSpace',
    meta: {
      rank: 1001,
      title: 'router_title_module.personal',
      icon: 'mingcute:user-2-line',
      belong: 'personal-space',
    },
    component: () => import('@/layout/index.vue'),
    redirect: '/personalSpaceLayout',
    children: [
      {
        path: '/personalSpaceLayout',
        name: 'PersonalSpaceLayout',
        meta: {
          rank: 1001,
          title: 'router_title_module.personal',
          belong: 'PersonalSpace',
        },
        component: () => import('@/views/personal-space/personal-space.vue'),
        redirect: '/personalSpace/app',
        children: [
          {
            path: '/personalSpace/app',
            name: 'PersonalSpaceApp',
            meta: {
              rank: 1001,
              title: 'router_title_module.agent_application',
              belong: 'PersonalSpace',
            },
            component: () => import('@/views/personal-space/personal-app/personal-app.vue'),
          },
        ],
      },
    ],
  },
  {
    path: '/personal-app-setting/:agentId?/:tabKey?',
    name: 'PersonalAppSetting',
    meta: {
      rank: 1001,
      title: 'router_title_module.app_setting',
      icon: 'mingcute:user-2-line',
      belong: 'PersonalAppSetting',
      hideSideMenItem: true,
    },
    component: () => import('@/views/personal-space/personal-app-setting/personal-app-setting.vue'),
  },
] as RouteRecordRaw[]
