import { defineStore } from 'pinia'
import { PersonalAppConfigState } from '../types/personal-app-config'

export function defaultPersonalAppConfigState(): PersonalAppConfigState {
  return {
    baseInfo: {
      agentId: '',
      agentTitle: '我的Agent应用',
      agentAvatar: 'https://gsst-poe-sit.gz.bcebos.com/data/20240911/1726041369632.webp',
      agentDesc: '',
      agentSystem: '',
      agentPublishStatus: 'draft',
    },
    commConfig: {
      preamble: '',
      featuredQuestions: [],
      continuousQuestionStatus: 'default',
      continuousQuestionSystem: '',
      continuousQuestionTurn: 3,
    },
    knowledgeConfig: {
      knowledgeIds: [],
    },
    commModelConfig: {
      largeModel: '文心4.0 （8K）',
      topP: 0.0,
      communicationTurn: 0,
    },
    modifiedTime: new Date(),
  }
}

export const usePersonalAppConfigStore = defineStore('personal-app-config-store', {
  state: (): PersonalAppConfigState => defaultPersonalAppConfigState(),

  actions: {
    updatePersonalAppConfigState(personalAppConfigState: Partial<PersonalAppConfigState>) {
      this.$state = { ...this.$state, ...personalAppConfigState }
    },

    resetPersonalAppConfigState() {
      this.$state = defaultPersonalAppConfigState()
    },
  },
})
