export interface PersonalAppConfigState {
  baseInfo: {
    agentId: string //应用ID
    agentTitle: string //应用标题
    agentAvatar: string //应用头像
    agentDesc: string //应用描述
    agentSystem: string //角色指令
    agentPublishStatus: 'draft' | 'publish' //发布状态  draft-草稿 publish-发布
  }
  commConfig: {
    preamble: string //开场白
    featuredQuestions: string[] //推荐问
    continuousQuestionStatus: 'default' | 'close' //追问状态
    continuousQuestionSystem: string // 追问提示词   customizable时必填
    continuousQuestionTurn: number // 追问轮次 1-5 customizable时必填
  }
  knowledgeConfig: {
    knowledgeIds: string[] //知识库ID
  }
  commModelConfig: {
    largeModel: string //大模型
    topP: number //多样性 0-1.00
    communicationTurn: number //参考对话轮次 0-100
  }
  modifiedTime: Date
}
