import { NImage, NPopover } from 'naive-ui'
import { h } from 'vue'
import CustomIcon from '@/components/custom-icon/custom-icon.vue'
import { PersonalAppConfigState } from '@/store/types/personal-app-config'
import { formatDateTime } from '@/utils/date-formatter'
import i18n from '@/locales'

const t = i18n.global.t

export function createPersonalAppColumn(handlePersonalAppTableAction: (actionType: string, agentId: string) => void) {
  return [
    {
      title: () => h('span', {}, t('personal_space_module.agent_module.agent_list_module.agent_title')),
      key: 'agentTitle',
      align: 'left',
      ellipsis: {
        tooltip: true,
      },
      width: 210,
      fixed: 'left',
      render(row: PersonalAppConfigState) {
        return h(
          'div',
          {
            style: {
              display: 'flex',
              justifyContent: 'center',
              alignItems: 'center',
            },
          },
          {
            default: () => [
              h(NImage, {
                width: '36px',
                src: row.baseInfo.agentAvatar || 'https://gsst-poe-sit.gz.bcebos.com/data/20240911/1726041369632.webp',
                showToolbar: false,
                previewDisabled: true,
                style: {
                  borderRadius: '8px',
                  height: '36px',
                },
              }),
              h(
                'span',
                {
                  style: {
                    marginLeft: '12px',
                    fontWeight: '600',
                    flex: '1',
                    whiteSpace: 'nowrap',
                    overflow: 'hidden',
                    textOverflow: 'ellipsis',
                  },
                  className: 'hover:text-theme-color cursor-pointer',
                  onClick: () => handlePersonalAppTableAction('edit', row.baseInfo.agentId),
                },
                {
                  default: () => [
                    h(
                      NPopover,
                      {
                        props: { placement: 'top' },
                        style: { maxWidth: '200px' },
                      },
                      {
                        trigger: () =>
                          h(
                            'span',
                            {
                              style: {
                                whiteSpace: 'nowrap',
                                overflow: 'hidden',
                                textOverflow: 'ellipsis',
                                width: '100%',
                                display: 'block',
                              },
                            },
                            row.baseInfo.agentTitle || '--',
                          ),
                        default: () => h('span', {}, row.baseInfo.agentTitle || '--'),
                      },
                    ),
                  ],
                },
              ),
            ],
          },
        )
      },
    },
    {
      title: () => h('span', {}, t('personal_space_module.agent_module.agent_list_module.large_model')),
      key: 'largeModel',
      align: 'left',
      ellipsis: {
        tooltip: true,
      },
      width: 210,
      render(row: PersonalAppConfigState) {
        return row.commModelConfig.largeModel
      },
    },
    {
      title: () => h('span', {}, t('personal_space_module.agent_module.agent_list_module.agent_id')),
      key: 'agentId',
      align: 'left',
      ellipsis: {
        tooltip: true,
      },
      width: 180,
      render(row: PersonalAppConfigState) {
        return h(
          'div',
          {
            style: {
              display: 'flex',
              justifyContent: 'center',
              alignItems: 'center',
            },
          },
          {
            default: () => [
              h(
                'span',
                {
                  style: {
                    flex: '1',
                    whiteSpace: 'nowrap',
                    overflow: 'hidden',
                    textOverflow: 'ellipsis',
                  },
                },
                {
                  default: () => [
                    h(
                      NPopover,
                      {
                        props: { placement: 'top' },
                      },
                      {
                        trigger: () => h('span', {}, row.baseInfo.agentId || '--'),
                        default: () => h('span', {}, row.baseInfo.agentId || '--'),
                      },
                    ),
                  ],
                },
              ),
              h(CustomIcon, {
                icon: 'ion:copy-outline',
                style: {
                  cursor: 'pointer',
                  color: '#000DFF',
                },
                onClick: () => handlePersonalAppTableAction('copyAgentId', row.baseInfo.agentId),
              }),
            ],
          },
        )
      },
    },
    {
      title: () => h('span', {}, t('personal_space_module.agent_module.agent_list_module.agent_publish_status')),
      key: 'agentPublishStatus',
      align: 'left',
      ellipsis: {
        tooltip: true,
      },
      width: 230,
      render(row: PersonalAppConfigState) {
        let publicText = '----'
        let publicIcon = 'ion:close-circle-outline'
        let bgColor = '#84868c'
        let color = '#f2f5f9'

        switch (row.baseInfo.agentPublishStatus) {
          case 'draft':
            publicText = 'personal_space_module.agent_module.agent_list_module.draft_status'
            publicIcon = 'gg:time'
            bgColor = '#f2f5f9'
            color = '#84868c'
            break
          case 'publish':
            publicText = 'personal_space_module.agent_module.agent_list_module.publish_status'
            publicIcon = 'gg:check-o'
            bgColor = '#ecffe6'
            color = '#30bf13'
            break
        }

        return [
          h(
            'div',
            { style: { display: 'flex', alignItems: 'center' } },
            {
              default: () => [
                h(
                  'div',
                  {
                    className: 'flex justify-center items-center',
                    style: {
                      backgroundColor: bgColor,
                      fontSize: '12px',
                      width: '72px',
                      height: '24px',
                      borderRadius: '4px',
                      marginRight: '6px',
                    },
                  },
                  {
                    default: () => [
                      h(CustomIcon, {
                        icon: publicIcon,
                        style: {
                          color,
                          fontSize: '16px',
                          marginRight: '4px',
                        },
                      }),
                      h(
                        'span',
                        {
                          style: {
                            color,
                          },
                        },
                        t(publicText),
                      ),
                    ],
                  },
                ),
                // row.baseInfo.agentPublishStatus === 'publish' && formatDateTime(row.modifiedTime),
              ],
            },
          ),
        ]
      },
    },
    {
      title: () => h('span', {}, t('personal_space_module.agent_module.agent_list_module.modified_time')),
      key: 'modifiedTime',
      align: 'left',
      ellipsis: {
        tooltip: true,
      },
      width: 170,
      render(row: PersonalAppConfigState) {
        return formatDateTime(row.modifiedTime)
      },
    },
    {
      title: () => h('span', {}, t('personal_space_module.agent_module.agent_list_module.channel')),
      key: 'channel',
      align: 'left',
      ellipsis: {
        tooltip: true,
      },
      width: 140,
      render(row: PersonalAppConfigState) {
        return [
          row.baseInfo.agentPublishStatus === 'publish'
            ? h(
                NPopover,
                {
                  props: { placement: 'top' },
                },
                {
                  trigger: () =>
                    h(
                      'div',
                      {
                        className: 'flex justify-center items-center',
                        style: {
                          backgroundColor: '#e6f0ff',
                          borderRadius: '4px',
                          padding: '6px',
                        },
                        onClick: () => handlePersonalAppTableAction('openPublishDetail', row.baseInfo.agentId),
                      },
                      {
                        default: () => [
                          h(CustomIcon, {
                            icon: 'icon-park-solid:computer',
                            style: {
                              fontSize: '16px',
                              cursor: 'pointer',
                              color: '#000DFF',
                            },
                          }),
                        ],
                      },
                    ),

                  default: () =>
                    h('span', {}, t('personal_space_module.agent_module.agent_list_module.channel_popover_text')),
                },
              )
            : '--',
        ]
      },
    },
    {
      title: () => h('span', {}, t('common_module.data_table_module.action')),
      key: 'action',
      align: 'left',
      ellipsis: {
        tooltip: true,
      },
      width: 190,
      fixed: 'right',
      render(row: PersonalAppConfigState) {
        return [
          h(
            'span',
            {
              style: { marginRight: '20px' },
              className: 'text-theme-color cursor-pointer hover:opacity-80',
              onClick: () => handlePersonalAppTableAction('edit', row.baseInfo.agentId),
            },
            { default: () => t('common_module.data_table_module.edit') },
          ),
          h(
            'span',
            {
              style: { marginRight: '20px' },
              className: 'text-theme-color cursor-pointer hover:opacity-80',
              onClick: () => handlePersonalAppTableAction('copy', row.baseInfo.agentId),
            },
            { default: () => t('common_module.data_table_module.copy') },
          ),
          h(
            'span',
            {
              style: { marginRight: '20px', color: '#F25744' },
              className: 'cursor-pointer hover:opacity-80',
              onClick: () => handlePersonalAppTableAction('delete', row.baseInfo.agentId),
            },
            { default: () => t('common_module.data_table_module.delete') },
          ),
        ]
      },
    },
  ]
}
