import { defineConfig } from 'unocss'

export default defineConfig({
  rules: [
    [
      /^bg-svg-([\w-]+)$/,
      ([, fname]) => ({ 'background-image': `url(@/assets/svgs/${fname}.svg)`, 'background-size': 'cover' }),
    ],
    [
      /^bg-px-([\w-]+)-(png|jpg|gif)$/,
      ([, fname, suffix]) => ({
        'background-image': `url(@/assets/images/${fname}.${suffix})`,
        'background-size': 'cover',
      }),
    ],
  ],
  theme: {
    colors: {
      'theme-color': '#000DFF',
      'hover-theme-color': '#575FFF',
      'active-color': '#EFF0FF',
      'font-color': '#333333',
      'gray-font-color': '#999999',
      'error-font-color': '#F25744',
    },
    height: {
      navbar: '56px',
      content: 'calc(100% - 56px)',
    },
    borderRadius: {
      theme: '5px',
    },
    animation: {
      keyframes: {
        'card-reverse': `{ 0% { transform: rotateY(0deg); } 100% { transform: rotateY(1turn); } }`,
      },
      durations: {
        'card-reverse': '1s',
      },
      timingFns: {
        'card-reverse': 'ease-in-out',
      },
      counts: {
        'card-reverse': '1',
      },
    },
  },
})
