import qs from 'qs'
import { request } from '@/utils/request'

export function fetchPluginCategoryKeyList<T>() {
  return request.post<T>('/bizAgentApplicationPluginRest/classificationList.json')
}

export function fetchPluginCategoryDetailInfoList<T>(payload: object) {
  return request.post<T>(
    '/bizAgentApplicationPluginRest/getList.json',
    { pagingInfo: { pageNo: 1, pageSize: 9999 } },
    {
      params: payload,
      paramsSerializer: function (params) {
        return qs.stringify(params, { arrayFormat: 'repeat' })
      },
    },
  )
}
