import { readonly } from 'vue'
import { useI18n } from 'vue-i18n'

export interface ToolbarAllConfig {
  [key: string]: {
    name: string
    toolGroupId: string
    iconName: string
    command: string
    isActive: boolean
    childActiveValue: string
    tooltipText: string
    isDisabled: boolean
    isShowTooltip: boolean
    isShowPopover: boolean
    submenuCmd?: {
      iconName: string
      label: string
      command: string
      isActive: boolean
    }[]
    cmdValues?: { label: string; value: string }[]
  }
}

export function useEditorToolbarConfig() {
  const { t } = useI18n()

  const toolbarAllConfig = readonly<ToolbarAllConfig>({
    ndo: {
      name: 'ndo',
      toolGroupId: '',
      iconName: 'icon-chexiao_huaban',
      command: 'Undo',
      isActive: false,
      childActiveValue: '',
      tooltipText: t('editor_module.cancel'), // 撤销
      isDisabled: true,
      isShowTooltip: false,
      isShowPopover: false,
      // submenuCmd: [],
      // cmdValues: [],
    },
    redo: {
      name: 'redo',
      toolGroupId: '',
      iconName: 'icon-zhongzuo_huaban',
      command: 'Redo',
      isActive: false,
      childActiveValue: '',
      tooltipText: t('editor_module.redo'), // 重做
      isDisabled: true,
      isShowTooltip: false,
      isShowPopover: false,
    },
    removeFormat: {
      name: 'removeFormat',
      toolGroupId: '',
      iconName: 'icon-qingchuyangshi',
      command: 'RemoveFormat',
      isActive: false,
      childActiveValue: '',
      tooltipText: t('editor_module.clear_style'), // 清除样式
      isDisabled: false,
      isShowTooltip: false,
      isShowPopover: false,
    },
    bold: {
      name: 'bold',
      toolGroupId: '',
      iconName: 'icon-cuti',
      command: 'Bold',
      isActive: false,
      childActiveValue: '',
      tooltipText: t('editor_module.bold_type'), // 粗体
      isDisabled: false,
      isShowTooltip: false,
      isShowPopover: false,
    },
    formatBlock: {
      name: 'formatBlock',
      toolGroupId: '',
      iconName: '',
      command: 'FormatBlock',
      isActive: false,
      childActiveValue: '',
      tooltipText: t('editor_module.text_and_title'), // 正文与标题
      isDisabled: false,
      isShowTooltip: false,
      isShowPopover: false,
      cmdValues: [
        { label: t('editor_module.main_body'), value: 'p' },
        { label: `${t('editor_module.title')}1`, value: 'h1' },
        { label: `${t('editor_module.title')}2`, value: 'h2' },
        { label: `${t('editor_module.title')}3`, value: 'h3' },
        { label: `${t('editor_module.title')}4`, value: 'h4' },
      ],
    },
    italic: {
      name: 'italic',
      toolGroupId: '',
      iconName: 'icon-zitixieti',
      command: 'Italic',
      isActive: false,
      childActiveValue: '',
      tooltipText: t('editor_module.italics'), // 斜体
      isDisabled: false,
      isShowTooltip: false,
      isShowPopover: false,
    },
    underline: {
      name: 'underline',
      toolGroupId: '',
      iconName: 'icon-xiahuaxian',
      command: 'Underline',
      isActive: false,
      childActiveValue: '',
      tooltipText: t('editor_module.underline'), // 下划线
      isDisabled: false,
      isShowTooltip: false,
      isShowPopover: false,
    },
    strikethrough: {
      name: 'strikethrough',
      toolGroupId: '',
      iconName: 'icon-shanchuxian',
      command: 'Strikethrough',
      isActive: false,
      childActiveValue: '',
      tooltipText: t('editor_module.strikeout_line'), // 删除线
      isDisabled: false,
      isShowTooltip: false,
      isShowPopover: false,
    },
    align: {
      name: 'align',
      toolGroupId: '',
      iconName: 'icon-zuoduiqi',
      command: '',
      isActive: false,
      childActiveValue: '',
      tooltipText: t('editor_module.alignment_mode'), // 对齐方式
      isDisabled: false,
      isShowTooltip: false,
      isShowPopover: false,
      submenuCmd: [
        {
          iconName: 'icon-zuoduiqi',
          label: t('editor_module.justification_left'), // 左对齐
          command: 'JustifyLeft',
          isActive: false,
        },
        {
          iconName: 'icon-juzhongduiqi',
          label: t('editor_module.center_align'), // 居中对齐
          command: 'JustifyCenter',
          isActive: false,
        },
        {
          iconName: 'icon-youduiqi',
          label: t('editor_module.justify_right'), // 右对齐
          command: 'JustifyRight',
          isActive: false,
        },
        {
          iconName: 'icon-zuoyouduiqi',
          label: t('editor_module.align_both_ends'), // 两端对齐
          command: 'JustifyFull',
          isActive: false,
        },
      ],
    },
  })

  return { toolbarAllConfig }
}
