import i18n from '@/locales'

const { t } = i18n.global

export interface DiversityModeItem {
  label: string
  value: string
  topP: number
  temperature: number
}

export const diversityModeList: DiversityModeItem[] = [
  {
    label: 'common_module.accurate_mode',
    value: 'accurate',
    topP: 0.1,
    temperature: 0.1,
  },
  {
    label: 'common_module.balance_mode',
    value: 'balance',
    topP: 0.7,
    temperature: 0.5,
  },
  {
    label: 'common_module.creative_mode',
    value: 'creative',
    topP: 0.7,
    temperature: 0.95,
  },
  {
    label: 'common_module.custom',
    value: 'custom',
    topP: 0.5,
    temperature: 0.8,
  },
]

export const communicationTurnOptions = [
  {
    label: t('common_module.count_session_rounds', { count: 1 }),
    value: 1,
  },
  {
    label: t('common_module.count_session_rounds', { count: 5 }),
    value: 5,
  },
  {
    label: t('common_module.count_session_rounds', { count: 10 }),
    value: 10,
  },
  {
    label: t('common_module.count_session_rounds', { count: 15 }),
    value: 15,
  },
]
