import { defineStore } from 'pinia'

export const useAppStore = defineStore('app-store', {
  state: () => ({
    layoutDevice: 'desktop',
    isMenuCollapse: false,
  }),
  actions: {
    toggleLayoutDevice(layoutDevice: 'desktop' | 'mobile') {
      if (this.layoutDevice !== layoutDevice) {
        this.layoutDevice = layoutDevice

        if (layoutDevice === 'mobile') {
          this.isMenuCollapse = true
        }
      }
    },
    toggleMenuCollapse(isCollapse: boolean) {
      if (this.isMenuCollapse !== isCollapse) {
        this.isMenuCollapse = isCollapse
      }
    },
  },
})
