import i18n from '@/locales'
import { DatabaseItemInterface } from './type.d'
import { formatDateTime } from '@/utils/date-formatter'

const t = i18n.global.t
export function createDatabaseColumn(handleDatabaseTableAction: (actionType: string, databaseId: number) => void) {
  return [
    {
      title: () => <span>{t('personal_space_module.database_module.db_title')}</span>,
      key: 'databaseName',
      align: 'left',
      ellipsis: {
        tooltip: { width: 'trigger' },
      },
      width: 210,
      fixed: 'left',
      render(row: DatabaseItemInterface) {
        return row.title || '--'
      },
    },
    {
      title: () => <span>{t('personal_space_module.database_module.db_desc')}</span>,
      key: 'databaseDesc',
      align: 'left',
      ellipsis: {
        tooltip: { width: 'trigger' },
      },
      width: 380,
      render(row: DatabaseItemInterface) {
        return row.desc || '--'
      },
    },
    {
      title: () => <span>{t('common_module.modified_time')}</span>,
      key: 'updateTime',
      align: 'left',
      ellipsis: {
        tooltip: true,
      },
      width: 170,
      render(row: DatabaseItemInterface) {
        return row.modifiedTime ? formatDateTime(row.modifiedTime) : '--'
      },
    },
    {
      title: () => <span>{t('common_module.data_table_module.action')}</span>,
      key: 'action',
      align: 'left',
      ellipsis: {
        tooltip: true,
      },
      width: 190,
      fixed: 'right',
      render(row: DatabaseItemInterface) {
        return (
          <div>
            <span
              className='text-theme-color mr-5 cursor-pointer hover:opacity-80'
              onClick={() => handleDatabaseTableAction('view', row.id)}
            >
              {t('common_module.data_table_module.view')}
            </span>
            {!row.example ? (
              <span
                className='text-theme-color mr-5 cursor-pointer hover:opacity-80'
                onClick={() => handleDatabaseTableAction('edit', row.id)}
              >
                {t('common_module.data_table_module.edit')}
              </span>
            ) : (
              ''
            )}
            {!row.example ? (
              <span
                className='text-error-font-color mr-5 cursor-pointer hover:opacity-80'
                onClick={() => handleDatabaseTableAction('delete', row.id)}
              >
                {t('common_module.data_table_module.delete')}
              </span>
            ) : (
              ''
            )}
          </div>
        )
      },
    },
  ]
}
