import { DBTableDataItemInterface, DBTableItemInterface } from './type'
import i18n from '@/locales'
import { formatDateTime } from '@/utils/date-formatter'

const t = i18n.global.t

export function createDatabaseColumn(handleDatabaseTableAction: (actionType: string, tableName: string) => void) {
  return [
    {
      title: () => <span>{t('personal_space_module.database_module.table_name')}</span>,
      key: 'name',
      align: 'left',
      ellipsis: {
        tooltip: true,
      },
      width: 210,
      fixed: 'left',
      render(row: DBTableItemInterface) {
        return row.name || '--'
      },
    },
    // {
    //   title: () => <span>数据表中文名</span>,
    //   key: 'chineseName',
    //   align: 'left',
    //   ellipsis: {
    //     tooltip: true,
    //   },
    //   width: 380,
    //   render(row: DBTableItemInterface) {
    //     return row.chineseName || '--'
    //   },
    // },
    {
      title: () => <span>{t('personal_space_module.database_module.table_desc')}</span>,
      key: 'docs',
      align: 'left',
      ellipsis: {
        tooltip: true,
      },
      width: 170,
      render(row: DBTableItemInterface) {
        return row.docs || '--'
      },
    },
    // {
    //   title: () => <span>创建时间</span>,
    //   key: 'createdTime',
    //   align: 'left',
    //   ellipsis: {
    //     tooltip: true,
    //   },
    //   width: 170,
    //   render(row: DBTableItemInterface) {
    //     return row.createdTime ? formatDateTime(row.createdTime) : '--'
    //   },
    // },
    // {
    //   title: () => <span>更新时间</span>,
    //   key: 'updatedTime',
    //   align: 'left',
    //   ellipsis: {
    //     tooltip: true,
    //   },
    //   width: 170,
    //   render(row: DBTableItemInterface) {
    //     return row.updatedTime ? formatDateTime(row.updatedTime) : '--'
    //   },
    // },
    {
      title: () => <span>{t('personal_space_module.database_module.table_data_volume')}</span>,
      key: 'dataSize',
      align: 'left',
      ellipsis: {
        tooltip: true,
      },
      width: 170,
      render(row: DBTableItemInterface) {
        return row.dataSize || '--'
      },
    },
    {
      title: () => <span>{t('common_module.data_table_module.action')}</span>,
      key: 'action',
      align: 'left',
      ellipsis: {
        tooltip: true,
      },
      width: 100,
      fixed: 'right',
      render(row: DBTableItemInterface) {
        return (
          <div>
            <span
              className='text-theme-color mr-5 cursor-pointer hover:opacity-80'
              onClick={() => {
                handleDatabaseTableAction('view', row.name)
              }}
            >
              {t('common_module.data_table_module.view')}
            </span>
          </div>
        )
      },
    },
  ]
}

export function createDatabaseTableDetailColumns(columns: string[] = []) {
  return [
    ...columns.map((column, index) => {
      return {
        title: column,
        key: column,
        align: 'left',
        ellipsis: {
          tooltip: {
            contentClass: 'max-w-[340px]',
          },
        },
        width: 170,
        render(row: DBTableDataItemInterface[]) {
          if (!row?.[index] || row[index].value === null || row[index].value === undefined) {
            return '--'
          }

          if (row[index]?.type === 'data' && row[index]?.value) {
            return formatDateTime(row?.[index]?.value)
          }

          return `${row[index]?.value}` || '--'
        },
      }
    }),
  ]
}
