export interface DatabaseTableInfoItem {
  table_NAME: string
  table_COMMENT: string
  table_ROWS: number
  table_COLUMN: number
}

export interface DatabaseItemInterface {
  id: number
  title: string
  desc: string
  dbType: string
  dbHost: string
  dbPort: number
  dbName: string
  dbUsername: string
  dbPassword: string
  modifiedTime: Date
  tableInfos: DatabaseTableInfoItem[]
}

export type DatabaseFormInterface = Omit<DatabaseItemInterface, 'id' | 'modifiedTime' | 'tableInfos'>
