import { type ComposerTranslation } from 'vue-i18n'
import { DBTableItemInterface } from './type'
// import { formatDateTime } from '@/utils/date-formatter'

export function createDatabaseColumn(_config: { t?: ComposerTranslation } = {}) {
  return [
    {
      title: () => <span>数据表名称</span>,
      key: 'name',
      align: 'left',
      ellipsis: {
        tooltip: true,
      },
      width: 210,
      fixed: 'left',
      render(row: DBTableItemInterface) {
        return row.name || '--'
      },
    },
    // {
    //   title: () => <span>数据表中文名</span>,
    //   key: 'chineseName',
    //   align: 'left',
    //   ellipsis: {
    //     tooltip: true,
    //   },
    //   width: 380,
    //   render(row: DBTableItemInterface) {
    //     return row.chineseName || '--'
    //   },
    // },
    {
      title: () => <span>数据表描述</span>,
      key: 'docs',
      align: 'left',
      ellipsis: {
        tooltip: true,
      },
      width: 170,
      render(row: DBTableItemInterface) {
        return row.docs || '--'
      },
    },
    // {
    //   title: () => <span>创建时间</span>,
    //   key: 'createdTime',
    //   align: 'left',
    //   ellipsis: {
    //     tooltip: true,
    //   },
    //   width: 170,
    //   render(row: DBTableItemInterface) {
    //     return row.createdTime ? formatDateTime(row.createdTime) : '--'
    //   },
    // },
    // {
    //   title: () => <span>更新时间</span>,
    //   key: 'updatedTime',
    //   align: 'left',
    //   ellipsis: {
    //     tooltip: true,
    //   },
    //   width: 170,
    //   render(row: DBTableItemInterface) {
    //     return row.updatedTime ? formatDateTime(row.updatedTime) : '--'
    //   },
    // },
    {
      title: () => <span>数据量</span>,
      key: 'dataSize',
      align: 'left',
      ellipsis: {
        tooltip: true,
      },
      width: 170,
      render(row: DBTableItemInterface) {
        return row.dataSize || '--'
      },
    },
    // {
    //   title: () => <span>{t('common_module.data_table_module.action')}</span>,
    //   key: 'action',
    //   align: 'left',
    //   ellipsis: {
    //     tooltip: true,
    //   },
    //   width: 190,
    //   fixed: 'right',
    //   render(row: DatabaseItemInterface) {
    //     return (
    //       <div>
    //         <span
    //           className='text-theme-color mr-5 cursor-pointer hover:opacity-80'
    //           onClick={() => handleDatabaseTableAction('view', row.id)}
    //         >
    //           {t('common_module.data_table_module.view')}
    //         </span>
    //         <span
    //           className='text-theme-color mr-5 cursor-pointer hover:opacity-80'
    //           onClick={() => handleDatabaseTableAction('edit', row.id)}
    //         >
    //           {t('common_module.data_table_module.edit')}
    //         </span>
    //         <span
    //           className='text-error-font-color mr-5 cursor-pointer hover:opacity-80'
    //           onClick={() => handleDatabaseTableAction('delete', row.id)}
    //         >
    //           {t('common_module.data_table_module.delete')}
    //         </span>
    //       </div>
    //     )
    //   },
    // },
  ]
}
